from selenium import webdriver
import os
from time import sleep

firefox_options = webdriver.FirefoxOptions()
firefox_options.headless = True
firefox_options.set_preference("dom.disable_open_during_load", True)
firefox_options.set_preference("dom.popup_allowed_events", "change click dblclick auxclick mousedown mouseup pointerdown pointerup notificationclick reset submit touchend contextmenu")
firefox_options.set_preference("dom.block_multiple_popups", True)

driver = webdriver.Remote(command_executor='http://firefox:4444/wd/hub',options=firefox_options)

#driver=webdriver.Firefox(options=firefox_options)

driver.set_page_load_timeout(15)

username="admin"
password=os.environ['ADMINPASSWD']
appHostname = os.environ['HOST']

def visit(title,url):
    print("[>] Visiting {} with the title {}".format(url,title))
    driver.get("{}/login".format(appHostname))
    driver.find_element_by_css_selector("input[name='username']").send_keys(username)
    driver.find_element_by_css_selector("input[name='password']").send_keys(password)
    driver.find_element_by_xpath("/html/body/section/div/div/div/div/form/div[3]/div/button").click()
    print("[*] Login successful")
    driver.get("about:blank")
    driver.get("{}".format(url))
    print("[*] Page loaded")
    sleep(3)
    driver.close()
    print("[<] Done")
    return

